import ScriptPortal.Vegas;
import System.Windows.Forms;
import Microsoft.Win32;

var plugInName = "Color Corrector";
var presetName = "Default";

try
{
for (var track in Vegas.Project.Tracks) {
for (var evnt in track.Events) {
if (!evnt.Selected || evnt.MediaType != MediaType.Video) continue;

var fx = Vegas.VideoFX;

var plugIn = fx.GetChildByName(plugInName);
if (null == plugIn) {
throw "could not find a plug-in named: '" + plugInName + "'";
}

var effect = new Effect(plugIn);
evnt.Effects.Add(effect);
if (null != presetName) {
effect.Preset = presetName;
}
}
}
}
catch (errorMsg)
{
MessageBox.Show(errorMsg, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
}